use Grid::GPT::Setup;
use Getopt::Long;

my $name		= 'jobmanager-boinc';
my $manager_type	= 'boinc';
my $c_opts		= '';
my $cmd;

GetOptions('service-name|s=s' => \$name,
	   'help|h' => \$help);

&usage if $help;

my $metadata =
    new Grid::GPT::Setup(package_name => "globus_gram_job_manager_setup_boinc");

my $globusdir	= $ENV{GLOBUS_LOCATION};
my $libexecdir	= "$globusdir/libexec";

mkdir $ENV{GLOBUS_LOCATION} . "/lib/perl/Globus/GRAM/JobManager", 0777;


print `./find-boinc-tools $c_opts --cache-file=/dev/null`;
if($? != 0)
{
    print STDERR "Error locating boinc commands, aborting!\n";
    exit 2;
}

# Create service
$cmd = "$libexecdir/globus-job-manager-service -add -m boinc -s \"$name\"";
system("$cmd >/dev/null 2>/dev/null");
if($? != 0)
{
    print STDERR "Error creating service entry $name. Aborting!\n";
    exit 3;
}

open(VALIDATION_FILE, ">$ENV{GLOBUS_LOCATION}/share/globus_gram_job_manager/boinc.rvf");

print VALIDATION_FILE <<EOF;
Attribute: boincsubmit
Description: "Allow the client to specify abitrary additional attributes to
             be included in the Boinc submit description file."
ValidWhen: GLOBUS_GRAM_JOB_SUBMIT
EOF

close VALIDATION_FILE;

$metadata->finish();

sub usage
{
    print "Usage: $0 [options]\n".
          "Options:  [-service-name|-s service_name]\n".
	  "          [-help]\n";
    exit 1;
}
